var arrows;
if (mUtil.isRTL()) {
    arrows = {
        leftArrow: '<i class="la la-angle-right"></i>',
        rightArrow: '<i class="la la-angle-left"></i>'
    }
} else {
    arrows = {
        leftArrow: '<i class="la la-angle-left"></i>',
        rightArrow: '<i class="la la-angle-right"></i>'
    }
}

function TextFieldCell(options) {

    this.ID = options && options.ID || "";
    this.TITLE1 = options && options.TITLE1 || "";
    this.TITLE2 = options && options.TITLE2 || "";
    this.PLACEHOLDER = options && options.PLACEHOLDER || "";
    this.VALUE = options && options.VALUE || "";
    this.HELP = options && options.HELP || "";
    this.PARENT = options && options.PARENT || "";
    this.onCHANGE = options && options.onCHANGE || "";
    this.INDEX = options && +(options.INDEX !== 0) && (options.INDEX || -1);
    this.isHIDDEN = options && options.isHIDDEN || false;
    this.isREADONLY = options && options.isREADONLY || false;
    this.isPASSWORD = options && options.isPASSWORD || false;
    this.isTEXTAREA = options && options.isTEXTAREA || false;
    this.isREADONLY = options && options.isREADONLY || false;
    var self = this;
    
    this.getHtml = function () {
        return '<div class="form-group m-form__group" id="' + self.ID + '_Div" ' + (self.isHIDDEN ? 'style="display: none"' : '') + '> <label>' + (Functions.LanguageSelect(self.TITLE1, self.TITLE2)) + '</label> <' + (self.isTEXTAREA ? 'textarea' : 'input') + ' ' + (self.isPASSWORD ? 'autocomplete="off" type="password"' : 'type="text"') + ' ' + (self.isREADONLY ? 'readonly' : '') + 'onchange="FIELDS[' + self.PARENT + '][' + self.INDEX + '].VALUE = $(this).val(); ' + this.onCHANGE + '" class="form-control m-input m-input--air m-input--pill ' + self.PARENT + '_' + self.INDEX + '_' + self.ID + ' ' + (self.isTEXTAREA ? 'textarea-autosize' : '') + '" ' + (self.isREADONLY ? 'disabled' : '') + ' name="' + self.ID + '" value="' + self.VALUE + '" placeholder="' + self.PLACEHOLDER + '" ' + (self.isTEXTAREA ? 'rows="3">' + self.VALUE + '</textarea' : '/') + '> <span class="m-form__help">' + self.HELP + '</span> </div>';
    };
}

function DropdownFieldCell(options) {

    this.ID = options && options.ID || "";
    this.TITLE1 = options && options.TITLE1 || "";
    this.TITLE2 = options && options.TITLE2 || "";
    this.PLACEHOLDER = options && options.PLACEHOLDER || "";
    this.OPTIONS = options && options.OPTIONS || "";
    this.VALUE = options && options.VALUE || "";
    this.HELP = options && options.HELP || "";
    this.PARENT = options && options.PARENT || "";
    this.onCHANGE = options && options.onCHANGE || "";
    this.INDEX = options && +(options.INDEX !== 0) && (options.INDEX || -1);
    this.isHIDDEN = options && options.isHIDDEN || false;
    this.isREADONLY = options && options.isREADONLY || false;
    this.isSELECT2 = options && options.isSELECT2 || false;
    this.isSELECTMULTIPLE = options && options.isSELECTMULTIPLE || false;
    this.isDROPDOWNOTHER = options && options.isDROPDOWNOTHER || false;
    var self = this;
    
    this.getHtml = function () {
        return '<div class="form-group m-form__group" id="' + self.ID + '_Div" ' + (self.isHIDDEN ? 'style="display: none"' : '') + '>' +
            '<label for="exampleSelect1">' + (Functions.LanguageSelect(self.TITLE1, self.TITLE2)) + '</label>' +
            (self.isSELECT2 ? '<div class="m-select2 m-select2--air m-select2--pill">' : '') +
            '<select class="form-control ' + (self.isSELECT2 ? 'm-select2 m-dropdown-select2" onchange="FIELDS[' + self.PARENT + '][' + self.INDEX + '].VALUE = $(this).val(); ' + this.onCHANGE + '" data-placeholder="' + self.PLACEHOLDER + '" ' : 'm-input m-input--air m-input--pill" ') + (self.isSELECTMULTIPLE ? 'multiple=""' : '') + ' ' + (self.isREADONLY ? 'disabled' : '') + ' name="' + self.ID + '">' +
            (self.OPTIONS == "" ? '<option></option>' : '<option></option>' + (self.OPTIONS.split(",")).map(function(e) {return '<option' + (e.indexOf('|') >= 0 ? ' value="' + e.split('|')[1] + '"' + (e.split('|')[1] == self.VALUE ? ' selected' : '') : (e.split('|')[0] == self.VALUE ? ' selected' : '')) + '>' + e.split('|')[0] + '</option>';}).join('')) + 
            '</select>' +
            '</div>' +
            (self.isSELECT2 ? '</div>' : '');
    };
}

function DateFieldCell(options) {

    this.ID = options && options.ID || "";
    this.TITLE1 = options && options.TITLE1 || "";
    this.TITLE2 = options && options.TITLE2 || "";
    this.PLACEHOLDER = options && options.PLACEHOLDER || "";
    this.VALUE = options && options.VALUE || "";
    this.HELP = options && options.HELP || "";
    this.PARENT = options && options.PARENT || "";
    this.onCHANGE = options && options.onCHANGE || "";
    this.INDEX = options && +(options.INDEX !== 0) && (options.INDEX || -1);
    this.TYPE = options && options.TYPE || "Datebox";
    this.isHIDDEN = options && options.isHIDDEN || false;
    this.isREADONLY = options && options.isREADONLY || false;
    this.isNOW = options && options.isNOW || false;
    this.isREADONLY = options && options.isREADONLY || false;
    var self = this;
    
    this.getHtml = function () {
        return '<div class="form-group m-form__group" id="' + self.ID + '_Div" ' + (self.isHIDDEN ? 'style="display: none"' : '') + '><label>' + (Functions.LanguageSelect(self.TITLE1, self.TITLE2)) + '</label><div class="m-input-list"><div class="input-group date"><input type="text" class="form-control m-input m-date m-input--air m-input--pill ' + self.PARENT + '_' + self.INDEX + '_' + self.ID + '" readonly placeholder="' + self.PLACEHOLDER + '" onchange="FIELDS[' + self.PARENT + '][' + self.INDEX + '].VALUE = $(this).val(); ' + this.onCHANGE + '" value="' + (self.VALUE == "" && self.isNOW ? DateFunctions.FormatDate() : self.VALUE) + '" ' + (self.isREADONLY ? 'disabled' : '') + ' name="' + self.ID + '" /><div class="input-group-append"><span class="input-group-text btn m-btn--pill disabled btn-outline-metal"><i class="la la-calendar"></i></span></div></div><span class="m-form__help">' + self.HELP + '</span></div></div>';
    };
}

function SwitchFieldCell(options) {

    this.ID = options && options.ID || "";
    this.TITLE1 = options && options.TITLE1 || "";
    this.TITLE2 = options && options.TITLE2 || "";
    this.VALUE = Functions.isTrue((options && options.VALUE || ""));
    this.HELP = options && options.HELP || "";
    this.PARENT = options && options.PARENT || "";
    this.onCHANGE = options && options.onCHANGE || "";
    this.INDEX = options && +(options.INDEX !== 0) && (options.INDEX || -1);
    this.isHIDDEN = options && options.isHIDDEN || false;
    this.isREADONLY = options && options.isREADONLY || false;
    this.isONOFF = options && options.isONOFF || false;
    this.ONTEXT = options && options.ONTEXT || "Yes";
    this.OFFTEXT = options && options.OFFTEXT || "No";
    this.COLOR = options && options.COLOR || "brand";
    this.isREADONLY = options && options.isREADONLY || false;
    var self = this;
    
    this.getHtml = function () {
        return '<div class="form-group m-form__group" id="' + self.ID + '_Div" ' + (self.isHIDDEN ? 'style="display: none"' : '') + '>' +
            '<label for="exampleInputEmail1">' + (Functions.LanguageSelect(self.TITLE1, self.TITLE2)) + '</label>' +
            '<div class="m-switch-list">' +
            (self.isONOFF ?
             '<input data-switch="true" ' + (self.isREADONLY ? 'disabled' : '') + ' type="checkbox" ' + (Functions.isTrue(self.VALUE) ? 'checked="checked"' : '') + ' data-on-text="' + self.ONTEXT + '" ' + (self.ONTEXT != "" && self.OFFTEXT != "" ? '' : 'data-handle-width="30"') + ' data-off-text="' + self.OFFTEXT + '" data-on-color="' + self.COLOR + '">'
             : 
            '<span class="m-switch m-switch--outline m-switch--icon m-switch--' + self.COLOR + '">' +
            '<label>' +
            '<input type="checkbox" ' + (self.isREADONLY ? 'disabled' : '') + ' ' + (Functions.isTrue(self.VALUE) ? 'checked="checked"' : '') + ' class="' + self.PARENT + '_' + self.INDEX + '_' + self.ID + '" onclick="FIELDS[' + self.PARENT + '][' + self.INDEX + '].VALUE = $(this)[0].checked; ' + this.onCHANGE + '" name="' + self.ID + '" >' +
            '<span></span>' +
            '</label>' +
            '</span>'
            ) +
            '</div>' +
            '<span class="m-form__help">' + self.HELP + '</span>' +
            '</div>';
    };
}


function DivisorFieldCell(options) {

    this.ID = options && options.ID || "";
    this.TITLE1 = options && options.TITLE1 || "";
    this.TITLE2 = options && options.TITLE2 || "";
    var self = this;
    
    this.getHtml = function () {
        return '<div class="alert m-alert m-alert--default" role="alert">' + (Functions.LanguageSelect(self.TITLE1, self.TITLE2)) + '</div>'
    };
}


//== Class definition

var BootstrapFunctions = function () {

    //== Private functions
    var dateFunctions = function () {

     // enable clear button 
     $('.m-date').each(function (i, e) {
         if (!$(e).data('datepicker')) {
             $(e).datepicker({
                 autoclose: true,
                 rtl: mUtil.isRTL(),
                 todayBtn: "linked",
                 clearBtn: true,
                 todayHighlight: true,
                 templates: arrows
             });
         }
     });
     $('.m-datetime').each(function (i, e) {
         if (!$(e).data('datetimepicker')) {
             $(e).datetimepicker({
                 format: "dd/mm/yyyy - HH:ii P",
                 showMeridian: true,
                 todayHighlight: true,
                 autoclose: true,
                 todayBtn: true,
                 pickerPosition: 'bottom-left'
             });
         }
     });
     $('.m-daterange').each(function (i, e) {
         if (!$(e).data('daterangepicker')) {
             $(e).daterangepicker({
                 buttonClasses: 'm-btn btn',
                 applyClass: 'btn-primary',
                 cancelClass: 'btn-secondary'
             }, function (start, end, label) {
                 $(e).val(start.format('MM/DD/YYYY') + ' - ' + end.format('MM/DD/YYYY'));
             });
         }
     });
     $('.m-time').each(function (i, e) {
         if (!$(e).data('timepicker')) {
             $(e).timepicker({
                minuteStep: 1,
                showMeridian: true
             });
         }
     });
    }
    
    var fieldFunctions = function () {
        
     $('.m-maxlength').each(function (i, e) {
         if (!$(e).data('maxlength')) {
             $(e).maxlength({
            threshold: 3,
            warningClass: "m-badge m-badge--warning m-badge--rounded m-badge--wide",
            limitReachedClass: "m-badge m-badge--danger m-badge--rounded m-badge--wide",
            separator: ' of ',
            preText: 'You have ',
            postText: ' chars remaining.',
            validate: true
        });
         }
     });
     $('.m-dropdown-select2').each(function (i, e) {
         if (!$(e).data('select2')) {
             $(e).select2({
                 placeholder: ($(e).attr('data-placeholder') ? $(e).attr('data-placeholder') : "Select an option")
             });
         }
     });
     $('.m-repeat').each(function (i, e) {
         if (!$(e).data('repeater')) {
             $(e).repeater({
                 initEmpty: false,

                 defaultValues: {
                     'text-input': 'foo'
                 },

                 show: function () {
                     $(this).slideDown();
                 },

                 hide: function (deleteElement) {
                     $(this).slideUp(deleteElement);
                 }
//                 isFirstItemUndeletable: true
             });
             
             //Function to populate field
//             var $repeater = $('.m-repeat').repeater();
//             $repeater.setList([
//                { 'TestRepeat': 'set-a' },
//                { 'TestRepeat': 'set-foo' }
//             ]);
         }
     });
     autosize($('.textarea-autosize'));
    }
    
    var otherFunctions = function () {
    
     $('[data-switch=true]').each(function (i, e) {
         if (!$(e).data('bootstrapSwitch')) {
             $(e).bootstrapSwitch();
         }
     });
    }

    return {
        // public functions
        init: function () {
            dateFunctions();
            fieldFunctions();
            otherFunctions();
        }
    }
}();

jQuery(document).ready(function () {
    BootstrapFunctions.init();
});